/*
 * Decompiled with CFR 0.152.
 */
package qz;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import qz.ByteUtilities;
import qz.LogIt;
import qz.reflection.Reflect;
import qz.reflection.ReflectException;

public class NetworkUtilities {
    private String ipAddress;
    private String macAddress;
    private String hostname = "www.google.com";
    private int port = 80;

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void gatherNetworkInfo() throws IOException, SocketException, UnknownHostException, ReflectException {
        Socket socket = new Socket();
        LogIt.log("Initiating a temporary connection to \"" + this.hostname + ":" + this.port + "\" to determine main Network Interface");
        InetSocketAddress endpoint = new InetSocketAddress(this.hostname, this.port);
        socket.connect(endpoint);
        InetAddress localAddress = socket.getLocalAddress();
        this.ipAddress = localAddress.getHostAddress();
        socket.close();
        System.out.println(localAddress.getHostAddress());
        NetworkInterface networkInterface = NetworkInterface.getByInetAddress(localAddress);
        Reflect r = Reflect.on(networkInterface);
        byte[] b = (byte[])r.call("getHardwareAddress").get();
        if (b != null && b.length > 0) {
            this.macAddress = ByteUtilities.bytesToHex(b);
        }
    }

    public String getHardwareAddress() {
        return this.macAddress;
    }

    public String getInetAddress() {
        return this.ipAddress;
    }
}

